'use client';
import { logout } from '@/utils';
import axios from 'axios';
import { useEffect, useState } from 'react';

const checkVersion = async () => {
  try {
    const response = await axios.get('/api/check-version');
    return response.data;
  } catch (err: unknown) {
    return null;
  }
};

const useCheckVersion = () => {
  const [shouldReload, setShouldReload] = useState<boolean>(false);
  const [version, setVersion] = useState<string>('');

  const handleVersion = async () => {
    const result = await checkVersion();
    if (!result) return;

    setVersion(result.version);

    if (result.forceReload) {
      logout('/uvod?expired=true');
    }

    if (!result.isUpToDate) {
      setShouldReload(true);
    }
  };

  useEffect(() => {
    handleVersion();
  }, []);

  return { version, shouldReload };
};

export default useCheckVersion;
