import type { Metadata } from 'next';
import { auth } from '@/auth';
import { Providers, Header } from '@/components';
import '@/styles/index.css';

export const metadata: Metadata = {
  title: 'Výber organizácie | Správca Košice',
  description: 'Admin portál správcu mesta Košice'
};

export default async function OrganizationsLayout({
  children
}: Readonly<{
  children: React.ReactNode;
}>) {
  const session = await auth();

  return (
    <html lang="sk">
      <Providers session={session}>
        <body className="flex flex-col bg-neutral-100">
          <Header />
          <main className="p-6">{children}</main>
        </body>
      </Providers>
    </html>
  );
}
