import React from 'react';

interface MessageListPlaceholder {
  children: React.ReactNode;
}

const MessageListPlaceholder: React.FC<MessageListPlaceholder> = ({ children }) => {
  return (
    <div className="border border-neutral-300 rounded-lg overflow-hidden">
      <div className="idsk-data-grid__head hidden tb2:grid p-5 grid-cols-12">
        <div className="col-span-2">Prijímateľ</div>
        <div className="col-span-4">Predmet</div>
        <div className="col-span-2">Téma</div>
        <div className="col-span-4 text-right">Dátum</div>
      </div>
      <div className="idsk-data-grid__head block tb2:hidden">
        <div className="w-full">Odosielateľ/Predmet/Téma/Dátum</div>
      </div>
      <div className="bg-white">{children}</div>
    </div>
  );
};

export default MessageListPlaceholder;
