'use client';

import React from 'react';
import { Tag } from '@/lib/idsk';
import { useTagTheme } from '@/hooks';

interface MessageTagProps {
  color: string;
  children: string;
  size?: 'medium' | 'small';
  className?: string;
}

const MessageTag: React.FC<MessageTagProps> = ({ color, children, className, size = 'medium' }) => {
  const { border, background, text } = useTagTheme(color);
  return <Tag className={className} label={children} size={size} colors={{ border, background, color: text }} />;
};

export default MessageTag;
