package sk.kosice.konto.kkmessageservice.repository.provider;

import static sk.kosice.konto.kkmessageservice.repository.model.Tables.MESSAGE;
import static sk.kosice.konto.kkmessageservice.repository.model.Tables.TOPIC;

import sk.kosice.konto.kkmessageservice.domain.common.listing.MessageListingAttribute;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqRsqlMetadata;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqRsqlMetadataConfigProvider;

public class MessageJooqRsqlMetadataConfigProvider implements JooqRsqlMetadataConfigProvider {

  @Override
  public void configure(JooqRsqlMetadata metadata) {
    metadata
        .addColumnInfo(MessageListingAttribute.TITLE.apiName(), MESSAGE.TITLE)
        .addColumnInfo(MessageListingAttribute.BODY.apiName(), MESSAGE.BODY)
        .addColumnInfo(MessageListingAttribute.CREATED_AT.apiName(), MESSAGE.CREATED_AT)
        .addColumnInfo(MessageListingAttribute.TOPIC_ID.apiName(), TOPIC.ID)
        .addColumnInfo(MessageListingAttribute.TOPIC_NAME.apiName(), TOPIC.NAME);
  }
}
