package sk.kosice.konto.kkmessageservice.repository.rsql.jooq.handler;

import java.util.stream.Stream;
import org.jooq.Record;
import org.jooq.SelectQuery;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ListingQuery;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqRsqlMetadataConfigProvider;

public class JooqPaginatedStreamSelectQueryHandler<Q extends ListingQuery<?>>
    implements JooqSelectQueryHandler<SelectQuery, Stream<Record>> {

  private final Q query;
  private final JooqOneParamSelectQueryHandler<SelectQuery> rsqlQueryHandler;
  private final JooqOneParamSelectQueryHandler<SelectQuery> orderingQueryHandler;

  public JooqPaginatedStreamSelectQueryHandler(
      Q query, JooqRsqlMetadataConfigProvider jooqListingMetadataConfigProvider) {
    this.query = query;
    this.rsqlQueryHandler =
        new JooqRsqlSelectQueryHandler(query.rsqlQuery(), jooqListingMetadataConfigProvider);
    this.orderingQueryHandler =
        new JooqOrderingSelectQueryHandler<>(
            query.orderings(), jooqListingMetadataConfigProvider, query.languageCodes());
  }

  @Override
  public Stream<Record> handle(SelectQuery dataQuery) {
    final SelectQuery dataQ = rsqlQueryHandler.handle(dataQuery);

    final SelectQuery orderedQuery = orderingQueryHandler.handle(dataQ);
    orderedQuery.addLimit(query.limit());
    orderedQuery.addOffset(query.offset());

    return orderedQuery.fetchStream();
  }
}
