package sk.kosice.konto.kkmessageservice.restapi.dto.common.error;

import static io.swagger.v3.oas.annotations.media.Schema.RequiredMode.REQUIRED;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.immutables.value.Value;

@JsonDeserialize(as = ImmutableErrorDetailResponseItem.class)
@JsonSerialize(as = ImmutableErrorDetailResponseItem.class)
@Value.Style(stagedBuilder = true)
@Value.Immutable
public interface ErrorDetailResponseItem {

  @Schema(
      description =
          "Unique identifier (name) of the microservice or external service that generated the given error.",
      requiredMode = REQUIRED,
      type = "string",
      example = "esvk-audit-service")
  String serviceId();

  @Schema(description = "Unique identifier of the error.", requiredMode = REQUIRED, type = "string")
  String faultCode();

  @Schema(
      description =
          "Error description in more detail. The whole message can be compiled using a list of items in faultMessageParams.",
      requiredMode = REQUIRED,
      type = "string",
      example = "This is example error message of %s service.")
  String faultMessage();

  @ArraySchema(
      schema =
          @Schema(
              description =
                  "A list of additional parameters to describe the error. These parameters can be used to create full error message using faultMessage string.",
              requiredMode = REQUIRED,
              type = "string",
              example = "audit"))
  List<String> faultMessageParams();
}
