package sk.kosice.konto.kkmessageservice.restapi.dto.message;

import static io.swagger.v3.oas.annotations.media.Schema.RequiredMode.NOT_REQUIRED;
import static io.swagger.v3.oas.annotations.media.Schema.RequiredMode.REQUIRED;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.immutables.value.Value;
import sk.kosice.konto.kkmessageservice.domain.common.enumeration.BodyType;
import sk.kosice.konto.kkmessageservice.domain.common.enumeration.Location;

@JsonDeserialize(as = ImmutableMessageCreateRequest.class)
@JsonSerialize(as = ImmutableMessageCreateRequest.class)
@Value.Immutable
public interface MessageCreateRequest {

  @Schema(requiredMode = REQUIRED, example = "Oznámenie XYP")
  @NotBlank
  @Size(max = 255)
  String getTitle();

  @Schema(requiredMode = REQUIRED, example = "5f4e4b9d-0b3d-4b3b-8b3b-3b3b3b3b3b3b")
  @NotNull
  UUID getTopicId();

  @Schema(
      requiredMode = NOT_REQUIRED,
      example =
          """
        [
           {
             "color": "#BD730C",
             "bgColor": "#BD730C",
             "value": "Lehota splatnosti: 15 dní"
           }
        ]
        """)
  Optional<List<JsonNode>> getTags();

  @Schema(requiredMode = REQUIRED, enumAsRef = true, example = "TEXT")
  @NotNull
  BodyType getBodyType();

  @Schema(requiredMode = REQUIRED, example = "Pekná dlhá správa")
  @NotBlank
  String getBody();

  @Schema(requiredMode = REQUIRED, example = "Pekná krátka správa")
  @NotBlank
  String getBodyShort();

  @ArraySchema(
      schema =
          @Schema(
              requiredMode = NOT_REQUIRED,
              implementation = ActionDto.class,
              example =
                  """
        [
            {
              "title": "1. Platba kartou online",
              "desc": "Najrýchlejší spôsob, ako zaplatiť miestnu daň, je priamo cez elektronickú platobnú bránu mesta. Pre rýchlu platbu kliknite na tlačidlo „Zaplať kartou“. Platba bude spracovaná okamžite.",
              "type": "OPEN_PAY_BY_CARD_URL",
              "value": "/pay/metadata",
              "metadata": [
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c8",
                  "type": "TEXT",
                  "key": "Platba za:",
                  "value": "miestnu daň z nehnuteľnosti"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c4",
                  "type": "PRICE",
                  "key": "Suma:",
                  "value": "150.00"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c3",
                  "type": "VARIABLE_SYMBOL",
                  "key": "Variabilný symbol:",
                  "value": "150.00"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c2",
                  "type": "IBAN",
                  "key": "Číslo účtu:",
                  "value": "SK3112000000198742637541"
                }
              ]
            },
            {
              "title": "Platba bankovým prevodom alebo PAY by square",
              "desc": "Využite možnosť úhrady prostredníctvom svojho internet bankingu alebo rýchlejšiu cestu skenovaním QR kódu nižšie.",
              "type": "SHOW_PAY_QR_CODE",
              "value": "",
              "metadata": [
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c8",
                  "type": "TEXT",
                  "key": "Platobné údaje:",
                  "value": ""
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c9",
                  "type": "TEXT",
                  "key": "Platba za:",
                  "value": "miestnu daň z nehnuteľnosti"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c7",
                  "type": "PRICE",
                  "key": "Suma:",
                  "value": "178.18"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c6",
                  "type": "VARIABLE_SYMBOL",
                  "key": "Variabilný symbol:",
                  "value": "3123216769"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c1",
                  "type": "CONSTANT_SYMBOL",
                  "key": "Konštantný symbol:",
                  "value": "0308"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c9",
                  "type": "SPECIFIC_SYMBOL",
                  "key": "Špecifický symbol:",
                  "value": "12146"
                },
                {
                  "id": "6ba7b810-9dad-11d1-80b4-10c04fd430c5",
                  "type": "IBAN",
                  "key": "Číslo účtu:",
                  "value": "SK1409000000000082128875"
                }
              ]
            }
          ]
      """))
  Optional<List<JsonNode>> getActions();

  @Schema(requiredMode = NOT_REQUIRED, example = "[\"KOSICE_STARE_MESTO\", \"KOSICE_BARCA\"]")
  List<Location> getLocations();
}
