package sk.kosice.konto.kkmessageservice.restapi.dto.organization;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;
import java.util.UUID;
import org.immutables.value.Value;

@JsonSerialize(as = ImmutableOrganizationDto.class)
@JsonDeserialize(as = ImmutableOrganizationDto.class)
@Value.Immutable
public interface OrganizationDto {

  @Schema(requiredMode = Schema.RequiredMode.REQUIRED)
  UUID getId();

  @Schema(requiredMode = Schema.RequiredMode.REQUIRED)
  boolean isCityDistrict();

  @Schema(requiredMode = Schema.RequiredMode.REQUIRED)
  String getName();

  @Schema(requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  Optional<String> getDescription();
}
