package sk.kosice.konto.kkmessageservice.restapi.dto.topic;

import static io.swagger.v3.oas.annotations.media.Schema.RequiredMode.REQUIRED;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import org.immutables.value.Value;

@JsonDeserialize(as = ImmutableBaseTopicDto.class)
@JsonSerialize(as = ImmutableBaseTopicDto.class)
@Value.Immutable
public interface BaseTopicDto {
  @Schema(requiredMode = REQUIRED, example = "Košický Magistrát")
  String getName();

  @Schema(requiredMode = REQUIRED, example = "Oznámenie XYP")
  String getDescription();
}
