package sk.kosice.konto.kkmessageservice.permission;

import static org.assertj.core.api.Assertions.assertThat;
import static sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType.FORBIDDEN;
import static sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType.UNAUTHORIZED;

import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpStatus;
import sk.kosice.konto.kkmessageservice.domain.common.enumeration.Permission;
import sk.kosice.konto.kkmessageservice.restapi.dto.common.error.ErrorDetailResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.permission.PermissionDto;
import sk.kosice.konto.kkmessageservice.restapi.dto.permission.PermissionListResponse;

public class PermissionListingFeatureSpec extends PermissionFeatureSpec {

  @Disabled
  @Test
  public void thatPermissionsCanBeRetrieved() {
    final var response =
        listPermissions(
            UUID.fromString(EMPLOYEE_SUB_CLAIM), HttpStatus.OK, PermissionListResponse.class);
    assertThat(response.items()).hasSize(3);

    // For Org 1 and Org 2
    assertThat(response.items())
        .hasSize(3)
        .extracting(p -> p.getOrganization().getId())
        .contains(ORGANIZATION_ID_1, ORGANIZATION_ID_2);

    assertThat(response.items())
        .extracting(PermissionDto::getPermissions)
        .contains(List.of(Permission.ACTION_MANAGE_MESSAGE, Permission.ACTION_MANAGE_TOPIC));

    // For random generated Org
    assertThat(response.items())
        .filteredOn(
            o ->
                !o.getOrganization().getId().equals(ORGANIZATION_ID_1)
                    && !o.getOrganization().getId().equals(ORGANIZATION_ID_2))
        .hasSize(1)
        .extracting(PermissionDto::getPermissions)
        .contains(List.of(Permission.ACTION_MANAGE_MESSAGE, Permission.ACTION_MANAGE_TOPIC));
  }

  @Test
  public void thatEmptyUserPermissionsCanBeRetrieved() {
    prepareInvalidPermissions();

    final var response =
        listPermissions(
            UUID.fromString(EMPLOYEE_SUB_CLAIM), HttpStatus.OK, PermissionListResponse.class);
    assertThat(response.items()).isEmpty();
  }

  @Test
  public void thatUserCannotAccessAnotherUserPermissions() {
    final var response =
        listPermissions(UUID.randomUUID(), HttpStatus.FORBIDDEN, ErrorDetailResponse.class);
    assertThat(response.primaryFault().get().faultCode()).isEqualTo(FORBIDDEN.toString());
  }

  @Test
  public void thatPermissionsCannotBeRetrievedWithoutJwt() {
    final var response =
        listPermissionsWithoutJwt(
            UUID.randomUUID(), HttpStatus.UNAUTHORIZED, ErrorDetailResponse.class);
    assertThat(response.primaryFault().get().faultCode()).isEqualTo(UNAUTHORIZED.toString());
  }
}
