package sk.kosice.konto.kkmessageservice.domain.topic.query;

import java.util.UUID;
import org.immutables.value.Value;
import sk.kosice.konto.kkmessageservice.domain.common.audit.ImmutableActorIdentity;
import sk.kosice.konto.kkmessageservice.domain.common.marker.AuditableQuery;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.TopicEntity;

@Value.Immutable
public interface FindTopicByIdQuery extends AuditableQuery {

  UUID organizationId();

  UUID id();

  static FindTopicByIdQuery of(UUID id, UUID organizationId, String actorId) {
    return ImmutableFindTopicByIdQuery.builder()
        .organizationId(organizationId)
        .id(id)
        .actorId(ImmutableActorIdentity.of(actorId))
        .build();
  }

  static FindTopicByIdQuery of(UUID id, UUID organizationId) {
    return ImmutableFindTopicByIdQuery.builder().organizationId(organizationId).id(id).build();
  }

  static FindTopicByIdQuery of(TopicEntity entity) {
    return ImmutableFindTopicByIdQuery.builder()
        .organizationId(entity.organizationId())
        .id(entity.id())
        .build();
  }
}
