package sk.kosice.konto.kknotificationservice.repository.message.error.constraint;

import sk.kosice.konto.kkmessageservice.repository.model.Keys;
import sk.kosice.konto.kkmessageservice.repository.model.Tables;
import sk.kosice.konto.kknotificationservice.domain.message.entity.MessageEntity;
import sk.kosice.konto.kknotificationservice.repository.error.ConstraintErrorCode;

public enum MessageConstraintErrorCode implements ConstraintErrorCode {
  MESSAGE_WITH_ID_ALREADY_EXISTS("Message with id '%s' already exists.") {
    @Override
    public String constraintName() {
      return Keys.MESSAGE_PKEY.getName();
    }

    @Override
    public String[] findParams(Object dataObject) {
      if (dataObject instanceof final MessageEntity insertData) {
        return new String[] {insertData.id().toString()};
      } else {
        return new String[] {"null"};
      }
    }
  }
/*,
RECIPIENT_DOES_NOT_EXIST("Recipient with kid '%s' does not exist.") {
  public String constraintName() {
    return Keys.MESSAGE__RECIPIENT_KID_FKEY.getName();
  }

  @Override
  public String[] findParams(Object dataObject) {
    if (dataObject instanceof final MessageEntity insertData) {
      return new String[] {insertData.recipientKid().get().toString()};
    }
    return new String[] {"null"};
  }

  @Override
  public ErrorCodeType type() {
    return ErrorCodeType.NOT_FOUND;
  }
}*/
;

  private final String template;

  MessageConstraintErrorCode(String template) {
    this.template = template;
  }

  @Override
  public String template() {
    return this.template;
  }

  @Override
  public String table() {
    return Tables.MESSAGE.getName();
  }

  @Override
  public abstract String constraintName();
}
