package sk.kosice.konto.kknotificationservice.restapi.controller.advice;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import sk.kosice.konto.kknotificationservice.domain.common.error.BusinessError;
import sk.kosice.konto.kknotificationservice.restapi.dto.common.error.ErrorDetailResponse;

public abstract class AdviceHandler<T extends Throwable> {

  private final String serviceId;
  private final BusinessError businessError;

  public AdviceHandler(String serviceId, BusinessError businessError) {
    this.serviceId = serviceId;
    this.businessError = businessError;
  }

  abstract ErrorDetailResponse body(T t);

  public ResponseEntity<ErrorDetailResponse> handle(T t) {
    final ErrorDetailResponse body = body(t);
    return ResponseEntity.status(businessError.code().type().getNumCode()).body(body);
  }

  public List<String> extractErrors(BindingResult bindingResult) {
    return bindingResult.getFieldErrors().stream()
        .map(error -> error.getField() + ": " + error.getDefaultMessage())
        .collect(Collectors.toList());
  }

  public String getServiceId() {
    return serviceId;
  }

  public BusinessError getBusinessError() {
    return businessError;
  }
}
