package sk.kosice.konto.kknotificationservice.restapi.controller.advice;

import org.springframework.web.bind.MethodArgumentNotValidException;
import sk.kosice.konto.kknotificationservice.domain.common.error.BusinessError;
import sk.kosice.konto.kknotificationservice.restapi.dto.common.error.ErrorDetailResponse;
import sk.kosice.konto.kknotificationservice.restapi.dto.common.error.ImmutableErrorDetailResponse;
import sk.kosice.konto.kknotificationservice.restapi.dto.common.error.ImmutableErrorDetailResponseItem;

public class MethodArgumentNotValidExceptionAdviceHandler
    extends AdviceHandler<MethodArgumentNotValidException> {

  private String correlationId;

  private MethodArgumentNotValidExceptionAdviceHandler(
      String serviceId, BusinessError businessError) {
    super(serviceId, businessError);
  }

  public MethodArgumentNotValidExceptionAdviceHandler(
      String serviceId, BusinessError businessError, String correlationId) {
    this(serviceId, businessError);
    this.correlationId = correlationId;
  }

  @Override
  ErrorDetailResponse body(MethodArgumentNotValidException e) {
    ImmutableErrorDetailResponseItem item =
        ImmutableErrorDetailResponseItem.builder()
            .serviceId(getServiceId())
            .faultCode(getBusinessError().code().toString())
            .faultMessage(getBusinessError().code().template())
            .addAllFaultMessageParams(extractErrors(e.getBindingResult()))
            .build();

    return ImmutableErrorDetailResponse.builder()
        .correlationId(correlationId)
        .addFault(item)
        .build();
  }
}
