package sk.kosice.konto.kknotificationservice.domain.email.error;

import static sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCodeType.BAD_REQUEST;

import sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCode;
import sk.kosice.konto.kknotificationservice.domain.common.error.ErrorCodeType;

public enum SendEmailErrorCode implements ErrorCode {
  RECEPIENT_KID_IS_EMPTY(BAD_REQUEST, "Recipient kid is empty, cannot send email.");

  private final ErrorCodeType type;
  private final String template;

  SendEmailErrorCode(ErrorCodeType type, String template) {
    this.type = type;
    this.template = template;
  }

  @Override
  public String template() {
    return this.template;
  }

  @Override
  public ErrorCodeType type() {
    return this.type;
  }
}
