import React from 'react';
import Link from 'next/link';
import { ErrorImg, Logo, SecondaryButton } from '@/lib/idsk';
import LogoKosice from '@/assets/logo_kosice.svg';

export default function NotFound() {
  return (
    <div>
      <header className="p-5">
        <div>
          <Link href="/">
            <Logo title="Moje Košice" image={<LogoKosice />} />
          </Link>
        </div>
      </header>
      <div className="flex flex-col items-center justify-center mt-7 mx-auto max-w-4xl gap-3 p-5">
        <ErrorImg className="max-w-[8rem] tb2:max-w-[16rem]" />
        <h2>404 - Stránka neexistuje</h2>
        <p className="idsk-text-body text-neutral-700 text-center">
          Je nám ľúto, stránka, ktorú hľadáte, neexistuje. Možno bola presunutá, vymazaná, alebo odkaz nie je správny.
          Skontrolujte URL adresu alebo sa vráťte na hlavnú stránku.
        </p>
        <Link href="/" className="mt-4">
          <SecondaryButton>Späť na hlavnú stránku</SecondaryButton>
        </Link>
      </div>
    </div>
  );
}
