import React from 'react';
import { PrimaryButton, SecondaryButton } from '@/lib/idsk';
import { useTranslations } from 'next-intl';
import Link from 'next/link';

type Props = {
  settingsHref: string;
  onAccept: () => void;
  onDecline: () => void;
};

export const CookieBannerActions: React.FC<Props> = ({ settingsHref, onAccept, onDecline }) => {
  const t = useTranslations('cookies');

  return (
    <div className="flex flex-col gap-2">
      <h3>{t('title')}</h3>
      <p>{t('subtitle')}</p>
      <p>{t('subtitle2')}</p>
      <div className="flex flex-col tb2:flex-row gap-2.5 mt-2">
        <PrimaryButton onClick={onAccept}>{t('acceptCookies')}</PrimaryButton>
        <PrimaryButton onClick={onDecline}>{t('declineCookies')}</PrimaryButton>
        <Link href={settingsHref} className="ml-auto w-full tb2:w-fit">
          <SecondaryButton fullWidth>{t('cookieSettings')}</SecondaryButton>
        </Link>
      </div>
    </div>
  );
};
