import React from 'react';
import EmptyIllustration from '@/assets/empty_illustration.svg';
import { cn } from '@/utils';

interface EmptyProps {
  title: string;
  description?: string;
  img?: React.ReactNode;
  asSection?: boolean;
}

const Empty: React.FC<EmptyProps> = ({
  title,
  description,
  asSection,
  img = <EmptyIllustration className="w-24 tb2:w-32" />
}) => (
  <div
    className={cn('flex flex-col items-center justify-center text-center mb-5', {
      'bg-white px-6 py-12 border border-neutral-300 rounded-xl': asSection
    })}
  >
    {img}
    <h4 className="mt-5">{title}</h4>
    {!!description && <p className="text-txt-grey idsk-text-body mt-2">{description}</p>}
  </div>
);

export default Empty;
