import React from 'react';

interface TableSectionProps {
  title: string;
  description: string;
  children?: React.ReactNode;
}

const TableSection: React.FC<TableSectionProps> = ({ title, description, children }) => (
  <div className="flex flex-col gap-5">
    <div>
      <h4>{title}</h4>
      <p className="text-txt-grey">{description}</p>
    </div>
    {children}
  </div>
);

export default TableSection;
