'use client';
import React from 'react';
import { useCheckVersion } from '@/hooks';
import dynamic from 'next/dynamic';
import { useTranslations } from 'next-intl';

const VersionCheckDialog = dynamic(() => import('./version-check-dialog'), { ssr: false });

const Version: React.FC = () => {
  const { version, shouldReload } = useCheckVersion();
  const t = useTranslations('utils');

  return (
    <>
      <VersionCheckDialog isOpen={shouldReload} />
      <span>{t('appVersion', { version })}</span>
    </>
  );
};

export default Version;
