import React from 'react';

const MessageSkeleton: React.FC = () => (
  <div className="bg-white rounded-lg p-5 w-full border border-neutral-300">
    <div>
      <div className="flex justify-between">
        <div className="p-3 w-[20%] animate-pulse bg-neutral-300 rounded" />
        <div className="p-1.5 w-[5%] animate-pulse bg-neutral-300 rounded" />
      </div>
      <div className="p-2 w-[35%] animate-pulse bg-neutral-300 rounded mt-4" />
      <div className="p-4 w-[10%] animate-pulse bg-neutral-300 rounded mt-5" />
    </div>
    <div className="flex flex-col gap-4 mt-12">
      <div className="p-2 w-[35%] animate-pulse bg-neutral-300 rounded" />
      <div className="p-2 w-[50%] animate-pulse bg-neutral-300 rounded" />
      <div className="p-2 w-[75%] animate-pulse bg-neutral-300 rounded" />
      <div className="p-2 w-[45%] animate-pulse bg-neutral-300 rounded" />
    </div>

    <div className="flex flex-col gap-4 mt-12">
      <div className="p-2 w-[25%] animate-pulse bg-neutral-300 rounded" />
      <div className="p-2 w-[60%] animate-pulse bg-neutral-300 rounded" />
      <div className="p-2 w-[50%] animate-pulse bg-neutral-300 rounded" />
      <div className="p-2 w-[30%] animate-pulse bg-neutral-300 rounded" />
    </div>

    <div className="flex flex-col gap-4 mt-12">
      <div className="p-2 w-[25%] animate-pulse bg-neutral-300 rounded" />
      <div className="p-2 w-[10%] animate-pulse bg-neutral-300 rounded" />
    </div>
  </div>
);

export default MessageSkeleton;
