'use client';
import React, { useMemo, useState } from 'react';
import { Eye, EyeClosed } from '@/components/icons';

interface BirthNumberProps {
  value: string;
}

const BirthNumber: React.FC<BirthNumberProps> = ({ value }) => {
  const [isVisible, setIsVisible] = useState(false);

  const birthNumber = useMemo(() => {
    if (!isVisible) return '******/****';
    return `${value.slice(0, 6)}/${value.slice(6)}`;
  }, [isVisible]);

  return (
    <div className="flex gap-4">
      <span className="w-28">{birthNumber}</span>
      <button onClick={() => setIsVisible(!isVisible)}>{isVisible ? <EyeClosed /> : <Eye />}</button>
    </div>
  );
};

export default BirthNumber;
