import React from 'react';
import { useTranslations } from 'next-intl';
import { DeleteIcon, TertiaryIconButton, TextButton } from '@/lib/idsk';
import { Organization } from '@/utils';

interface SubscriptionProps extends Organization {
  onEdit: () => void;
  onDelete: () => void;
}

const Subscription: React.FC<SubscriptionProps> = ({ onEdit, onDelete, ...props }) => {
  const t = useTranslations('profile_page');

  return (
    <div className="py-5 px-5 tb2:px-10 bg-white [&:not(:last-child)]:border-b border-neutral-300 flex flex-col tb1:flex-row justify-between tb1:items-center tb1:gap-5">
      <div className="flex flex-col tb1:gap-2">
        <h4>{props.name}</h4>
        {props.description && <p className="text-neutral-700">{props.description}</p>}
      </div>
      <div className="flex items-center gap-7 justify-between tb1:ml-auto">
        <TextButton onClick={onEdit} className="px-0 tb1:px-4">
          {t('edit')}
        </TextButton>
        <TertiaryIconButton onClick={onDelete} icon={<DeleteIcon />} variant="warning" />
      </div>
    </div>
  );
};

export default Subscription;
