'use client';

import React from 'react';
import Link from 'next/link';
import { useSession } from 'next-auth/react';
import { useEffect } from 'react';
import { useTranslations } from 'next-intl';
import { ErrorDialog, PrimaryButton, SecondaryButton } from '@/lib/idsk';
import { useRouter, useSearchParams } from 'next/navigation';
import { logout } from '@/utils';

const SessionExpiredDialog = () => {
  const session = useSession();
  const searchParams = useSearchParams();
  const router = useRouter();

  const isOpen = searchParams.get('expired') === 'true';

  const t = useTranslations('utils');

  useEffect(() => {
    if (session.status !== 'loading' && session.data?.error === 'RefreshTokenError' && !isOpen) {
      logout('/uvod?expired=true');
    }
  }, [session.status, session.data]);

  return (
    <ErrorDialog className="error-dialog--custom" opened={isOpen} title={t('session_expired')}>
      <p className="idsk-text-body text-neutral-700">{t('session_expired_desc')}</p>
      <Link href="/signin">
        <PrimaryButton fullWidth>{t('login')}</PrimaryButton>
      </Link>
      <SecondaryButton onClick={() => router.replace('/uvod')}>{t('close')}</SecondaryButton>
    </ErrorDialog>
  );
};

export default SessionExpiredDialog;
