import { useQuery } from '@tanstack/react-query';
import axios from 'axios';
import { api, Properties, RequestError } from '@/utils';
import { getRequestError } from '@/utils/api/error';

const QUERY_KEY = 'properties';

const getProperties = async (kid: string, page: number, pageSize: number) => {
  try {
    const { data } = await axios.get(api.properties(kid), {
      params: {
        start: (page - 1) * pageSize,
        limit: pageSize
      }
    });
    return data;
  } catch (err) {
    throw getRequestError(err);
  }
};

const useGetProperties = (kid: string, page: number, pageSize: number, options?: any) =>
  useQuery<Properties, RequestError>({
    queryKey: [QUERY_KEY, page, pageSize],
    queryFn: () => getProperties(kid, page, pageSize),
    ...options
  });

export default useGetProperties;
