import axios from 'axios';
import { useMutation, useQueryClient } from '@tanstack/react-query';
import { useTranslations } from 'next-intl';
import { api } from '@/utils';
import useNotifications from '@/hooks/use-notification';

const deleteSubscription = async (userId: string, organizationId: string) => {
  await axios.delete(api.subscriptions(userId), { params: { filter: `organizationId==${organizationId}` } });
};

const useDeleteSubscription = (userId: string, organizationId: string, onClose: () => void) => {
  const t = useTranslations('profile_page');
  const notify = useNotifications();
  const queryClient = useQueryClient();

  return useMutation({
    mutationKey: ['subscriptions', userId],
    mutationFn: () => deleteSubscription(userId, organizationId),
    onSuccess: () => {
      queryClient.invalidateQueries({ queryKey: ['subscriptions'] });
      notify(t('delete_success'));
      onClose();
    },
    onError: () => notify({ message: t('delete_error'), variant: 'warning' })
  });
};

export default useDeleteSubscription;
