export type Provider = 'microsoft-entra-id' | 'microsoft-entra-id-signup';

export const providerCache = {
  value: null as Provider | null,
  get() {
    return this.value;
  },
  set(provider: Provider) {
    this.value = provider;
  },
  delete() {
    this.value = null;
  }
};

export const getPolicy = (provider: Provider) => {
  const policies: Record<Provider, string> = {
    'microsoft-entra-id': process.env.AZURE_AD_SIGNIN_POLICY as string,
    'microsoft-entra-id-signup': process.env.AZURE_AD_SIGNUP_POLICY as string
  };
  return policies[provider];
};
