import { AxiosResponse } from 'axios';
import { getRequestError } from './error';

export const api = {
  profile: (kid: string) => `/api/v1/kk/profiles/${kid}`,
  messages: (kid: string) => `/api/v1/kkmessage/recipients/${kid}/messages`,
  meessageDetail: (kid: string, id: string) => `/api/v1/kkmessage/recipients/${kid}/messages/${id}`,
  family: (kid: string) => `/api/v1/kk/profiles/${kid}/family`,
  properties: (kid: string) => `/api/v1/kk/profiles/${kid}/properties`,
  pets: (kid: string) => `/api/v1/kk/profiles/${kid}/pets`,
  organizations: () => `/api/v1/kkmessage/organizations`,
  organizationsForKid: (kid: string) => `/api/v1/kkmessage/recipients/${kid}/organizations`,
  subscriptions: (kid: string) => `/api/v1/kkmessage/recipients/${kid}/subscriptions`,
  subscriptionDetail: (kid: string, id: string) => `/api/v1/kkmessage/recipients/${kid}/subscriptions/${id}`
};

export const unwrap = async <T>(promise: Promise<AxiosResponse<T>>): Promise<T> => {
  try {
    const response = await promise;
    return response.data;
  } catch (err) {
    throw getRequestError(err);
  }
};
