package sk.kosice.konto.kknotificationservice.mailjet;

import static sk.kosice.konto.kknotificationservice.mailjet.error.MailjetClientErrorCode.MAILJET_CLIENT_INTERNAL_ERROR;

import com.mailjet.client.MailjetClient;
import com.mailjet.client.MailjetRequest;
import com.mailjet.client.MailjetResponse;
import com.mailjet.client.errors.MailjetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sk.kosice.konto.kknotificationservice.business.email.port.outbound.EmailSenderPort;
import sk.kosice.konto.kknotificationservice.domain.common.error.BusinessException;
import sk.kosice.konto.kknotificationservice.domain.email.command.SendEmailCommand;
import sk.kosice.konto.kknotificationservice.mailjet.error.handler.MailjetClientResponseHandler;
import sk.kosice.konto.kknotificationservice.mailjet.mapper.MailjetClientAdapterMapper;

@Component
public class MailjetClientAdapter implements EmailSenderPort {
  private static final Logger log = LoggerFactory.getLogger(MailjetClientAdapter.class);

  private final MailjetClient mailjetClient;

  @Autowired
  public MailjetClientAdapter(MailjetClient mailjetClient) {
    this.mailjetClient = mailjetClient;
  }

  @Override
  public void sendEmail(SendEmailCommand command) throws BusinessException {
    log.debug("Sending email with Mailjet");

    final MailjetRequest request = MailjetClientAdapterMapper.map(command);
    MailjetResponse response;

    try {
      response = mailjetClient.post(request);
    } catch (MailjetException e) {
      log.warn("Error while sending email with Mailjet", e);
      throw MAILJET_CLIENT_INTERNAL_ERROR.createError(e.getMessage()).convertToException();
    }

    MailjetClientResponseHandler.handleResponse(response);
    log.debug("Email sent successfully");
  }
}
