package sk.kosice.konto.kknotificationservice.repository.recipient;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;

import org.junit.jupiter.api.Test;
import sk.kosice.konto.kknotificationservice.domain.recipient.entity.RecipientEntity;

public class JooqRecipientRepositoryMergeTest extends JooqRecipientRepositoryTest {

  @Test
  public void thatNotExistingRecipientCanBeInserted() {
    final RecipientEntity insertData = prepareRecipientData();
    final RecipientEntity result = mergeAndFindRecipient(recipientRepository, insertData);

    assertThat(result).isNotNull();
    assertThat(result.kid()).isEqualTo(insertData.kid());
    assertThat(result.email()).isEqualTo(insertData.email());
  }

  @Test
  public void thatExistingRecipientCanBeUpdated() {
    final RecipientEntity existing =
        mergeAndFindRecipient(recipientRepository, prepareRecipientData());

    final RecipientEntity updateData =
        prepareRecipientData().withKid(existing.kid()).withEmail("petko@kosice.sk");

    final RecipientEntity updated = mergeAndFindRecipient(recipientRepository, updateData);

    assertThat(updated).isNotNull();
    assertThat(updated.kid()).isEqualTo(existing.kid());
    assertThat(updated.email()).isEqualTo(updateData.email());
  }
}
