package sk.kosice.konto.kkmessageservice.repository.topic.error.constraint;

import sk.kosice.konto.kkmessageservice.domain.topic.entity.TopicEntity;
import sk.kosice.konto.kkmessageservice.repository.error.ConstraintErrorCode;
import sk.kosice.konto.kkmessageservice.repository.model.Keys;
import sk.kosice.konto.kkmessageservice.repository.model.Tables;

public enum TopicConstraintErrorCode implements ConstraintErrorCode {
  TOPIC_WITH_ID_ALREADY_EXISTS("Topic with id '%s' already exists.") {
    @Override
    public String constraintName() {
      return Keys.TOPIC_PKEY.getName();
    }

    @Override
    public String[] findParams(Object dataObject) {
      if (dataObject instanceof final TopicEntity insertData) {
        return new String[] {insertData.id().toString()};
      } else {
        return new String[] {"null"};
      }
    }
  },
  TOPIC_WITH_NAME_ALREADY_EXISTS_IN_ORGANIZATION(
      "Topic with name '%s' already exists in organization with name '%s' and id '%s'.") {
    @Override
    public String constraintName() {
      return Keys.UNIQUE_TOPIC_NAME_ORGANIZATION_ID.getName();
    }

    @Override
    public String[] findParams(Object dataObject) {
      if (dataObject instanceof final TopicEntity insertData) {
        return new String[] {
          insertData.name(), insertData.organizationName(), insertData.organizationId().toString()
        };
      } else {
        return new String[] {"null"};
      }
    }
  };

  private final String template;

  TopicConstraintErrorCode(String template) {
    this.template = template;
  }

  @Override
  public String template() {
    return this.template;
  }

  @Override
  public String table() {
    return Tables.TOPIC.getName();
  }

  @Override
  public abstract String constraintName();
}
