package sk.kosice.konto.kkmessageservice.business.subscription.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.subscription.port.inbound.ListSubscriptionUseCase;
import sk.kosice.konto.kkmessageservice.business.subscription.port.inbound.SubscriptionInitializationForRecipientUseCase;
import sk.kosice.konto.kkmessageservice.business.subscription.port.outbound.QuerySubscriptionPort;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.ImmutableSubscriptionInitializationForRecipientCommand;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.ListOfSubscriptions;
import sk.kosice.konto.kkmessageservice.domain.subscription.query.SubscriptionListingQuery;

@Named
public class ListSubscriptionService extends AbstractService implements ListSubscriptionUseCase {

  private final SubscriptionInitializationForRecipientUseCase
      subscriptionInitializationForRecipientUseCase;
  private final QuerySubscriptionPort querySubscriptionPort;

  @Inject
  public ListSubscriptionService(
      SubscriptionInitializationForRecipientUseCase subscriptionInitializationForRecipientUseCase,
      QuerySubscriptionPort querySubscriptionPort) {
    this.subscriptionInitializationForRecipientUseCase =
        subscriptionInitializationForRecipientUseCase;
    this.querySubscriptionPort = querySubscriptionPort;
  }

  @Override
  public ListOfSubscriptions execute(SubscriptionListingQuery query) {
    final var subscriptions = querySubscriptionPort.list(query);

    if (query.rsqlQuery().isEmpty() && subscriptions.items().isEmpty()) {
      subscriptionInitializationForRecipientUseCase.execute(
          ImmutableSubscriptionInitializationForRecipientCommand.builder()
              .recipientKid(query.recipientKid())
              .build());
    }

    return querySubscriptionPort.list(query);
  }
}
