package sk.kosice.konto.kkmessageservice.business.subscription.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.subscription.port.inbound.UpdateSubscriptionUseCase;
import sk.kosice.konto.kkmessageservice.business.subscription.port.outbound.PersistSubscriptionPort;
import sk.kosice.konto.kkmessageservice.business.subscription.port.outbound.QuerySubscriptionPort;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.UpdateSubscriptionCommand;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.ImmutableBaseSubscriptionEntity;
import sk.kosice.konto.kkmessageservice.domain.subscription.query.FindSubscriptionByIdQuery;

@Named
public class UpdateSubscriptionService extends AbstractService
    implements UpdateSubscriptionUseCase {

  private final PersistSubscriptionPort persistSubscriptionPort;
  private final QuerySubscriptionPort querySubscriptionPort;

  @Inject
  public UpdateSubscriptionService(
      PersistSubscriptionPort persistSubscriptionPort,
      QuerySubscriptionPort querySubscriptionPort) {
    this.persistSubscriptionPort = persistSubscriptionPort;
    this.querySubscriptionPort = querySubscriptionPort;
  }

  @Override
  public void execute(UpdateSubscriptionCommand command) {
    querySubscriptionPort.findOne(
        FindSubscriptionByIdQuery.of(command.id(), command.recipientKid()));

    persistSubscriptionPort.update(
        ImmutableBaseSubscriptionEntity.builder()
            .id(command.id())
            .isEmailEnabled(command.isEmailEnabled())
            .build());
  }
}
