package sk.kosice.konto.kkmessageservice.domain.common.listing;

import sk.kosice.konto.kkmessageservice.domain.common.listing.common.ListingAttribute;

public enum TopicListingAttribute implements ListingAttribute {
  NAME("name", true, true),
  DESCRIPTION("description", false, true),
  ORGANIZATION_ID("organizationId", false, true),
  ORGANIZATION_NAME("organizationName", true, true);

  private final String apiName;
  private final boolean forSorting;
  private final boolean forFiltering;
  private final boolean isTranslated;

  TopicListingAttribute(String apiName, boolean forSorting, boolean forFiltering) {
    this(apiName, forSorting, forFiltering, false);
  }

  TopicListingAttribute(
      String apiName, boolean forSorting, boolean forFiltering, boolean isTranslated) {
    this.apiName = apiName;
    this.forSorting = forSorting;
    this.forFiltering = forFiltering;
    this.isTranslated = isTranslated;
  }

  @Override
  public String apiName() {
    return apiName;
  }

  @Override
  public boolean isForSorting() {
    return forSorting;
  }

  @Override
  public boolean isForFiltering() {
    return forFiltering;
  }

  @Override
  public Boolean isTranslated() {
    return isTranslated;
  }
}
