package sk.kosice.konto.kkmessageservice.repository.error;

import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCode;
import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType;

public enum DbErrorCode implements ErrorCode {
  UNHANDLED_DB_ERROR("Unhandled database error. Please contact technical support.") {
    public ErrorCodeType type() {
      return ErrorCodeType.INTERNAL;
    }
  },
  DB_ERROR("DB error: %s.");

  private final String template;

  DbErrorCode(String template) {
    this.template = template;
  }

  @Override
  public String template() {
    return this.template;
  }

  @Override
  public ErrorCodeType type() {
    return ErrorCodeType.BAD_REQUEST;
  }
}
