package sk.kosice.konto.kkmessageservice.restapi.dto.message;

import static io.swagger.v3.oas.annotations.media.Schema.RequiredMode.NOT_REQUIRED;
import static io.swagger.v3.oas.annotations.media.Schema.RequiredMode.REQUIRED;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.immutables.value.Value;

@JsonDeserialize(as = ImmutableBaseMessageDto.class)
@JsonSerialize(as = ImmutableBaseMessageDto.class)
@Value.Immutable
public interface BaseMessageDto {

  @Schema(requiredMode = REQUIRED, example = "0dc059b4-db1a-4692-9698-e32429b23bfe")
  UUID getId();

  @Schema(requiredMode = REQUIRED, example = "Košický Magistrát")
  String getSenderName();

  @Schema(requiredMode = REQUIRED, example = "Oznámenie XYP")
  String getTitle();

  @Schema(requiredMode = REQUIRED)
  MessageTopicDto getTopic();

  @Schema(
      requiredMode = NOT_REQUIRED,
      example =
          """
    [
       {
         "color": "#BD730C",
         "bgColor": "#BD730C",
         "value": "Lehota splatnosti: 15 dní"
       }
    ]
    """)
  Optional<List<JsonNode>> getTags();

  @Schema(requiredMode = REQUIRED, example = "2024-10-14T15:48:18.065674+02:00")
  OffsetDateTime getCreatedAt();

  @Schema(example = "0dc059b4-db1a-4692-9698-e32429b23bfe")
  UUID getSenderId();

  static BaseMessageDto of(MessageDetailResponse detailResponse) {
    return ImmutableBaseMessageDto.builder()
        .id(detailResponse.getId())
        .senderName(detailResponse.getSenderName())
        .title(detailResponse.getTitle())
        .topic(detailResponse.getTopic())
        .createdAt(detailResponse.getCreatedAt())
        .senderId(detailResponse.getSenderId())
        .tags(detailResponse.getTags())
        .build();
  }
}
