package sk.kosice.konto.kkmessageservice.restapi.springdoc.restapi.springdoc.annotation;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import sk.kosice.konto.kkmessageservice.domain.common.listing.common.ListingAttribute;

@Retention(RetentionPolicy.RUNTIME)
@Parameter(
    in = ParameterIn.QUERY,
    description =
        """
  Filter query parameter.<br /><br />
  <b>supported logical operators:</b><br />
  <table>
    <tr>
      <td width="100">Logical AND</td>
      <td><b>;</b> or <b>and</b></td>
    </tr>
    <tr>
      <td>Logical OR</td>
      <td><b>,</b> or <b>or</b></td>
    </tr>
  </table><br />
  <b>supported comparison operators:</b><br />
  <table>
    <tr>
      <td width="100">Equal to</td>
      <td><b>==</b></td>
    </tr>
    <tr>
      <td>Not equal to</td>
      <td><b>!=</b></td>
    </tr>
    <tr>
      <td>Less than</td>
      <td><b>=lt=</b> or <b>&lt;</b></td>
    </tr>
    <tr>
      <td>Less than or equal to</td>
      <td><b>=le=</b> or <b>&lt;=</b></td>
    </tr>
    <tr>
      <td>Greater than</td>
      <td><b>=gt=</b> or <b>></b></td>
    </tr>
    <tr>
      <td>Greater than or equal to</td>
      <td><b>=ge=</b> or <b>>=</b></td>
    </tr>
    <tr>
      <td>In</td>
      <td><b>=in=</b></td>
    </tr>
    <tr>
      <td>Not in</td>
      <td><b>=out=</b></td>
    </tr>
    <tr>
      <td>Like</td>
      <td><b>=like=</b></td>
    </tr>
  </table><br />
""",
    name = "filter",
    schema = @Schema(type = "string"))
public @interface FilterParameter {

  Class<? extends Enum<? extends ListingAttribute>> listingAttributeClass();

  String example() default "";
}
