package sk.kosice.konto.kkmessageservice.scheduler;

import jakarta.inject.Inject;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import sk.kosice.konto.kkmessageservice.business.topic.port.inbound.SynchronizeTopicOrganizationNameUseCase;

public class SynchronizeTopicOrganizationNameJob {

  private static final Logger log =
      LoggerFactory.getLogger(SynchronizeTopicOrganizationNameJob.class);
  private final SynchronizeTopicOrganizationNameUseCase synchronizeTopicOrganizationNameUseCase;

  @Inject
  public SynchronizeTopicOrganizationNameJob(
      SynchronizeTopicOrganizationNameUseCase synchronizeTopicOrganizationNameUseCase) {
    this.synchronizeTopicOrganizationNameUseCase = synchronizeTopicOrganizationNameUseCase;
  }

  @Scheduled(
      cron = "${sk.kosice.message.scheduler.organization-name-synchronizer.cron:0 0 * * * *}")
  @SchedulerLock(
      name = "synchronizeTopicOrganizationNames",
      lockAtMostFor =
          "${sk.kosice.message.scheduler.organization-name-synchronizer.lock-at-most-for}")
  public void synchronizeTopicOrganizationNames() {
    log.info("Checking organization names");

    synchronizeTopicOrganizationNameUseCase.execute();

    log.info("Checking organization names has finished.");
  }
}
