package sk.kosice.konto.kkmessageservice.config.error;

import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCode;
import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType;

public enum BusinessConfigErrorCode implements ErrorCode {
  UNDEFINED_ADMIN_ROLE_ID(ErrorCodeType.INTERNAL, "Admin role id is not defined."),
  UNDEFINED_ADMIN_GLOBAL_ROLE_ID(ErrorCodeType.INTERNAL, "Admin global role is not defined.");

  private final ErrorCodeType type;
  private final String template;

  BusinessConfigErrorCode(ErrorCodeType type, String template) {
    this.type = type;
    this.template = template;
  }

  @Override
  public String template() {
    return this.template;
  }

  @Override
  public ErrorCodeType type() {
    return this.type;
  }
}
