package sk.kosice.konto.kkmessageservice.business.organization.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.organization.port.inbound.ListOrganizationUseCase;
import sk.kosice.konto.kkmessageservice.business.organization.port.outbound.QueryOrganizationPort;
import sk.kosice.konto.kkmessageservice.domain.organization.entity.OrganizationEntity;
import sk.kosice.konto.kkmessageservice.domain.organization.query.OrganizationListingQuery;

@Named
public class ListOrganizationService extends AbstractService implements ListOrganizationUseCase {

  private final QueryOrganizationPort queryOrganizationPort;

  @Inject
  public ListOrganizationService(QueryOrganizationPort queryOrganizationPort) {
    this.queryOrganizationPort = queryOrganizationPort;
  }

  @Override
  public List<OrganizationEntity> execute(OrganizationListingQuery query) {
    return queryOrganizationPort.list(query.rootOrganizationId());
  }
}
