import React from 'react';

interface CardProps {
  title: string;
  icon?: React.ReactNode;
  children?: React.ReactNode;
  action?: React.ReactNode;
}

const Card: React.FC<CardProps> = ({ title, children, action, icon }) => (
  <div className="border border-neutral-300 rounded-md bg-white">
    <div className="flex justify-between items-center border-b border-neutral-300 p-5 tb2:p-7">
      {icon ? (
        <div className="flex gap-2.5 items-center">
          <h3>{title}</h3>
          {icon}
        </div>
      ) : (
        <h3>{title}</h3>
      )}
      {action}
    </div>
    <div className="p-5 tb2:p-7">{children}</div>
  </div>
);

export default Card;
