'use client';

import React from 'react';
import { useTranslations } from 'next-intl';
import { Card } from '@/components/core';
import Family from './Family';
import { useBreakpoint } from '@/hooks';
import Pets from './Pets';
import Property from './Property';
import { InfoIcon, Tooltip } from '@/lib/idsk';

interface FamilyAndPropertyProps {
  session: any;
}

const FamilyAndProperty: React.FC<FamilyAndPropertyProps> = ({ session }) => {
  const t = useTranslations('my_data');

  const { Breakpoints, match } = useBreakpoint();
  const view = match(Breakpoints.tb1) ? 'table' : 'list';

  return (
    <Card
      title={t('family_and_property')}
      icon={
        <Tooltip tooltip={t('family_tooltip')}>
          <InfoIcon className="text-primary-medium" width="1.5em" height="1.5em" />
        </Tooltip>
      }
    >
      <div className="flex flex-col gap-9">
        <Family session={session} view={view} />
        <Pets session={session} view={view} />
        <Property session={session} view={view} />
      </div>
    </Card>
  );
};

export default FamilyAndProperty;
