import axios from 'axios';
import { useQuery } from '@tanstack/react-query';
import { api, Organization, Page, RequestError } from '@/utils';

const QUERY_KEY = ['organizations'];

const getOrganizations = async (): Promise<Page<Organization>> => {
  const { data } = await axios.get<Page<Organization>>(api.organizations());
  return data;
};

const useGetOrganizations = () =>
  useQuery<Page<Organization>, RequestError>({ queryKey: QUERY_KEY, queryFn: getOrganizations });

export default useGetOrganizations;
