'use client';

import React, { useState } from 'react';
import { Dialog, PeopleIcon, PersonIcon, PrimaryButton, BaseButton } from '@/lib/idsk';
import NewMessageForm from './NewMessageForm';
import { useNotifications } from '@/hooks';
import { cn } from '@/utils';

type NewMessageType = 'general' | 'personal';

const NewMessageDialog: React.FC = () => {
  const [isOpen, setIsOpen] = useState<boolean>(false);
  const [type, setType] = useState<NewMessageType | null>(null);
  const notify = useNotifications();

  const handleClose = () => {
    setIsOpen(false);
    setType(null);
  };

  const handleMessageSent = () => {
    handleClose();
    notify('Správa bola úspešne odslaná');
  };

  return (
    <>
      <PrimaryButton className="w-full tb1:w-auto" onClick={() => setIsOpen(true)}>
        Vytvoriť správu
      </PrimaryButton>
      <Dialog
        // @ts-ignore
        className={cn({ 'dialog--fullscreen': !!type })}
        title="Nová správa"
        opened={isOpen}
        toggleOpened={handleClose}
        disableClickOutside
      >
        <div className="w-full">
          {type ? (
            <NewMessageForm type={type} onSuccess={handleMessageSent} />
          ) : (
            <div className="flex flex-col gap-4">
              <BaseButton
                ariaLabel="Všeobecná správa"
                className="block w-full text-xl p-4 border text-left border-neutral-300 rounded-lg hover:border-black whitespace-normal"
                onClick={() => setType('general')}
              >
                <PeopleIcon className="text-primary-medium text-[2rem]" />
                <b className="text-primary-medium mt-2 block">Všeobecná správa</b>
                <p className="text-neutral-600">Správá uvidia všetci obyvatelia mesta.</p>
              </BaseButton>

              <BaseButton
                ariaLabel="Personalizovaná správa"
                className="block w-full text-xl p-4 border text-left border-neutral-300 rounded-lg hover:border-black whitespace-normal"
                onClick={() => setType('personal')}
              >
                <PersonIcon className="text-primary-medium text-[2rem]" />
                <b className="text-primary-medium mt-2 block">Personalizovaná správa</b>
                <p className="text-neutral-600">Správá bude odoslaná konkrétnemu občanovi.</p>
              </BaseButton>
            </div>
          )}
        </div>
      </Dialog>
    </>
  );
};

export default NewMessageDialog;
