import React from 'react';
import TopicsListPlaceholder from './TopicsListPlaceholder';

const TopicsListSkeleton: React.FC<{ pageSize: number }> = ({ pageSize }) => (
  <TopicsListPlaceholder>
    {Array.from({ length: pageSize }).map((_, index) => (
      <div
        key={index}
        className="px-7 py-3 bg-white last:rounded-b-lg border-t border-neutral-300 flex flex-col gap-2.5 tb2:grid grid-cols-12"
      >
        <div className="animate-pulse bg-neutral-300 col-span-3 tb2:mr-6 h-6 my-2.5 rounded" />
        <div className="animate-pulse bg-neutral-300 col-span-8 tb2:mr-6 h-6 my-2.5 rounded" />
        <div className="col-span-1 h-4 my-2.5 rounded flex gap-3 justify-between tb2:justify-end">
          <div className="animate-pulse bg-neutral-300 h-6 w-16 rounded"></div>
          <div className="animate-pulse bg-neutral-300 h-6 w-6 rounded"></div>
        </div>
      </div>
    ))}
  </TopicsListPlaceholder>
);

export default TopicsListSkeleton;
