import React from 'react';

interface ContentLayoutProps {
  title: string;
  actions?: React.ReactNode;
  children?: React.ReactNode;
}

const ContentLayout: React.FC<ContentLayoutProps> = ({ title, actions, children }) => {
  return (
    <>
      {actions ? (
        <div className="tb1:flex-row flex-col flex justify-between mb-7 tb1:gap-4">
          <h2>{title}</h2>
          <div className="content-layout-actions flex flex-col-reverse tb1:flex-row gap-3 items-center mt-3 tb1:mt-0">
            {actions}
          </div>
        </div>
      ) : (
        <h2 className="mb-7">{title}</h2>
      )}

      {children}
    </>
  );
};

export default ContentLayout;
