import React from 'react';
import QueryProvider from './QueryProvider';
import NotificationsProvider from './NotificationsProvider';
import { SessionProvider } from 'next-auth/react';

interface ProvidersProps {
  session: any;
  children: React.ReactNode;
}

const Providers: React.FC<ProvidersProps> = ({ session, children }) => {
  return (
    <QueryProvider>
      <NotificationsProvider>
        <SessionProvider session={session}>{children}</SessionProvider>
      </NotificationsProvider>
    </QueryProvider>
  );
};

export default Providers;
