'use client';

import { SnackbarProps } from '@/lib/idsk';
import { createContext, useContext } from 'react';

interface NotificationsContextType {
  notifications: SnackbarProps[];
  setNotifications: React.Dispatch<React.SetStateAction<SnackbarProps[]>>;
}

export const NotificationsContext = createContext<NotificationsContextType | null>(null);

export const useNotificationsContext = () => {
  const ctx = useContext(NotificationsContext);
  if (!ctx) {
    throw new Error('useNotifications must be used within a NotificationsProvider');
  }
  return ctx;
};
