package sk.kosice.konto.kkmessageservice.repository.rsql.jooq.handler.mapper;

import java.util.function.Function;
import java.util.stream.Stream;
import org.jooq.Record;
import org.jooq.SelectQuery;
import sk.kosice.konto.kkmessageservice.domain.common.TriFunction;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ListingQuery;
import sk.kosice.konto.kkmessageservice.domain.common.listing.PaginatedResult;

public interface PaginatedResultMapper<
    LISTING extends ListingQuery, RESULT extends PaginatedResult> {

  RESULT map(TriFunction<Stream<Record>, Integer, LISTING, RESULT> fn);

  <RECORDS> RESULT map(
      Function<SelectQuery, RECORDS> records, TriFunction<RECORDS, Integer, LISTING, RESULT> fn);
}
